#include "CameraCBuffer.hlsli"
#include "SamplerStates.hlsli"

Texture2D RenderTargetTex : register(t0);
Texture2D BokehFgBlurTex : register(t1);
Texture2D BokehBgBlurTex : register(t2);
Texture2D<float2> DepthAndCoCRadiusTex : register(t3);

#include "Common.hlsli"
#include "Tonemapping.hlsli"

struct PSInput {
	float4 PositionViewportS : SV_Position;
	float2 TexCoords : TEXCOORD0;
};

float4 main(PSInput input) : SV_TARGET
{
	// TODO: See if masking/stencils will improve output quality/performance

	float2 depthAndCoCRadius = DepthAndCoCRadiusTex.SampleLevel(LinearSampler, input.TexCoords, 0);
	float4 output = float4(0, 0, 0, 0);

	float linearDepth = depthAndCoCRadius.r;
	float CoCRadiusFilmS = depthAndCoCRadius.g;
	float CoCDiameterPixelS = (2 * CoCRadiusFilmS) * ImageWidth / FilmWidth;

	float blendThreshold = kMinCoCPixels * 1.5; // Below this threshold, the unblurred image will also be blended into the output.

	// ----- Blend the output in order from bottom to top: bgBlur, unblurred, fgBlur -----
	// If background blur is not occluded, use it in the output
	if(linearDepth > FocalDistance) {
		output = BokehBgBlurTex.SampleLevel(LinearSampler, input.TexCoords, 0);
	}
	// If the current pixel's CoC isn't too large, alpha blend the unblurred output on top
	if(CoCDiameterPixelS < blendThreshold) {
		float4 unblurred = RenderTargetTex.SampleLevel(LinearSampler, input.TexCoords, 0);
		float invA = 1 - unblurred.a;
		output *= invA;
		output += unblurred;
	}
	// Alpha blend any foreground blur on top
	float4 fgBlur = BokehFgBlurTex.SampleLevel(LinearSampler, input.TexCoords, 0);
	float invA = 1 - fgBlur.a;
	output *= invA;
	output += fgBlur;

	// Normalize if sum of alpha values is not 1
	float normFactor = 1 / output.a;
	output *= normFactor;

	return output;
}